Scriptname zBFSIceRandom extends activemagiceffect  

Spell property BFSDeadSpell auto
Spell property BFSDeadMagicSpell auto
Spell property BFSDeadShaderSpell auto

EffectShader property BlankShader auto
EffectShader property IceEffectShader auto
EffectShader property FreezeTexture auto
EffectShader property FreezeTextureInstant auto

actor target
race targetrace
int random
bool bShader = false
bool RunOnce

;;; Applies the efect randomly, used in traps because they don't have perks
EVENT OnEffectStart(Actor akTarget, Actor akCaster)
	target = akTarget
	targetrace = target.GetRace()
endEvent


EVENT OnEffectFinish(Actor akTarget, Actor akCaster)
	if target.IsDead() && !RunOnce
		random = Utility.RandomInt(0, 15)				;;; Determine which effect will play
		;;; Sets RunOnce to true so effects doesn't apply again
		RunOnce = true

																		;;; If < 5 don't apply any effect
		if random >= 5 && !target.HasSpell(BFSDeadShaderSpell)			;;; If >=5 applies the freeze texture
			BlankShader.play(target)	;;; This will remove any shader to allow the skin shader to be applied without problems
			FreezeTexture.play(target)
			target.AddSpell(BFSDeadSpell, false)
			target.AddSpell(BFSDeadShaderSpell, false)
			bShader = true
		endif

		if random >= 10 && !target.HasSpell(BFSDeadMagicSpell)			;;; If >=10 applies the ice spiked effect
			IceEffectShader.play(target)
			target.AddSpell(BFSDeadMagicSpell, false)
		endif
	endif

	if bShader == true
		FreezeTextureInstant.play(target)
	endif
endEvent